/** 
 * @file    kLightExt.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LIGHT_EXT_X_H
#define K_FIRESYNC_LIGHT_EXT_X_H

#include <kApi/Data/kXml.h>

#define kLIGHT_EXT_DEFAULT_STATE_CAPACITY          (k8U_MAX)         

typedef struct kLightExtClass
{
    kObjectClass base; 
    kLight light;                   //Optional reference to light; used in client-side validation/verification. 
    kLightExtension typeId;         //Numeric type identifier. 
    kBool isSequence;               //Does this extension implement state sequencing logic?
    kBool requiresInterrupts;       //Does this extension require SoE/EoE interrupts to be enabled?
    kBool isEnabled;                //Is the extension currently enabled?
    kSize minStateCount;            //Can be set by child types to communicate minimum required light states. 
    kSize maxStateCount;            //Can be set by child types to communicate maximum supported light states. 
} kLightExtClass; 

typedef struct kLightExtVTable
{
    kObjectVTable base; 
    kStatus (kCall* VRead)(kLightExt extension, kXml xml, kXml item);    
    kStatus (kCall* VWrite)(kLightExt extension, kXml xml, kXml item);    
    kStatus (kCall* VVerify)(kLightExt extension); 
    kStatus (kCall* VClear)(kLightExt extension); 
    kStatus (kCall* VNextStates)(kLightExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
    k64u (kCall* VMinimumPeriod)(kLightExt extension); 
} kLightExtVTable; 

kDeclareVirtualClassEx(kFs, kLightExt, kObject)

kFsFx(kStatus) kLightExt_Construct(kLightExt* extension, kType type, kAlloc allocator); 

kFsFx(kStatus) kLightExt_Load(kLightExt* extension, kXml xml, kXmlItem item, kAlloc allocator); 
kFsFx(kStatus) kLightExt_Save(kLightExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLightExt_Init(kLightExt extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kLightExt_VRelease(kLightExt extension); 

kFsFx(kLightExtension) kLightExt_TypeId(kLightExt extension); 

kFsFx(kStatus) kLightExt_Read(kLightExt extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLightExt_VRead(kLightExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLightExt_Write(kLightExt extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLightExt_VWrite(kLightExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLightExt_SetLight(kLightExt extension, kLight light); 

kFsFx(kStatus) kLightExt_Clear(kLightExt extension); 
kFsFx(kStatus) kLightExt_VClear(kLightExt extension); 

kFsFx(kStatus) kLightExt_Verify(kLightExt extension); 
kFsFx(kStatus) kLightExt_VVerify(kLightExt extension); 

kFsFx(kBool) kLightExt_IsSequence(kLightExt extension); 
kFsFx(kBool) kLightExt_RequiresInterrupts(kLightExt extension); 

kFsFx(kStatus) kLightExt_NextStates(kLightExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(kStatus) kLightExt_VNextStates(kLightExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 

kFsFx(k64u) kLightExt_MinimumPeriod(kLightExt extension); 
kFsFx(k64u) kLightExt_VMinimumPeriod(kLightExt extension); 

kFsFx(kSize) kLightExt_MinStateCount(kLightExt extension); 
kFsFx(kSize) kLightExt_MaxStateCount(kLightExt extension); 

#endif
