/** 
 * @file    kRc940Info.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_RC940_INFO_X_H
#define K_FIRESYNC_RC940_INFO_X_H

#define kRC940_TOP_BLACK_COL                    (0)

#define kRC940_MIN_WIDTH                        (8)                 ///< Imager minimum width (pixels).
#define kRC940_MAX_WIDTH                        (640)               ///< Imager maximum width (pixels).
#define kRC940_WIDTH_GRANULARITY                (8)                 ///< Imager width granularity (pixels).
#define kRC940_MIN_HEIGHT                       (1)                 ///< Imager minimum height (pixels).
#define kRC940_MAX_HEIGHT                       (480)               ///< Imager maximum height (pixels).
#define kRC940_HEIGHT_GRANULARITY               (1)                 ///< Imager height granularity (pixels).
#define kRC940_LEFT_GRANULARITY                 (8)                 ///< Window x granularity (pixels). 
#define kRC940_TOP_GRANULARITY                  (1)                 ///< Window y granularity (pixels). 

#define kRC940_PRE_EXPOSURE                          (2000)              ///< Lead in (ns).
#define kRC940_POST_EXPOSURE                         (0)                 ///< Lead out (ns).

#define kRC940_MIN_EXPOSURE                     (2990)              ///< Minimum exposure (ns).
#define kRC940_MAX_EXPOSURE                     (1000000000)        ///< Maximum exposure (ns).

#define kRC940_MAX_IMAGER_X_SUB                 (1)                 ///< Maximum x-subsampling supported by imager.
#define kRC940_MAX_IMAGER_Y_SUB                 (2)                 ///< Maximum y-subsampling supported by imager.
#define kRC940_MIN_BLACK_LEVEL                  (0)                 ///< Minimum black level value.
#define kRC940_MAX_BLACK_LEVEL                  (0xFF)              ///< Maximum black level value.

#define kRC940_READOUT_ROW_OVERHEAD             (32)                ///< Constant readout time per row (pixel clock periods). 
                                                                    //// According to LUPA-300 datasheet, ROT = 32 clock periods @ 66MHz system clock (GRAN<1:0> = 10). 

#define kRC940_READOUT_FRAME_OVERHEAD           (7100)              ///< Constant readout time per frame (ns). 
                                                                    //// According to LUPA-300 App note 1, FOT = 600 clock @ 66MHz (65536) = 9.155us; Measured 7.1us

#define kRC940_READOUT_BLANKING_ROWS            (0)                 ///< Hold time after readout, expressed in rows.  
#define kRC940_MIN_INTER_EXPOSURE_GAP           (4120)              ///< Minimum time between end of exposure and start of next exposure (ns). 
#define kRC940_MIN_INTER_READOUT_GAP            (9520)              ///< Minimum time between end of readout and start of next readout (ns).  

typedef struct kRc940InfoClass
{
    kCameraInfoClass base; 

    kArrayList digitalFactors;
} kRc940InfoClass; 

kDeclareClassEx(kFs, kRc940Info, kCameraInfo)
        
kFsFx(kStatus) kRc940Info_Init(kRc940Info info, kType type, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc alloc);
kFsFx(kStatus) kRc940Info_VRelease(kRc940Info info);

kFsFx(kBool) kRc940Info_VHasGainChannel(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kRc940Info_VMaxGainStep(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kRc940Info_VGainStep(kRc940Info info, kCameraGain channel, k64f gain);
kFsFx(k64f) kRc940Info_VGainFactor(kRc940Info info, kCameraGain channel, k32u index);

kFsFx(k32u) kRc940Info_DigitalGainStep(kRc940Info info, k64f gain);
kFsFx(k64f) kRc940Info_DigitalGainFactor(kRc940Info info, k32u index);

kFsFx(kStatus) kRc940Info_ComposeDigitalGain(kRc940Info info);

kFsFx(k64f) kRc940Info_ReadoutTime(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VReadoutTime(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VMinInterExposureGap(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VMinInterReadoutGap(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VMinExposure(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VMaxExposure(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VPreExposure(kRc940Info info, const kCameraInfoParams* params);
kFsFx(k64f) kRc940Info_VPostExposure(kRc940Info info, const kCameraInfoParams* params);

kFsFx(kBool) kRc940Info_VIsWidthGrouped(kRc940Info info);
kFsFx(kBool) kRc940Info_VIsHeightGrouped(kRc940Info info);
kFsFx(kBool) kRc940Info_VIsTopGrouped(kRc940Info info);
kFsFx(kBool) kRc940Info_VIsLeftGrouped(kRc940Info info);

kFsFx(kCameraExtension) kRc940Info_VExtensionTypes(kRc940Info info);

#endif
