/** 
 * @file    kRc940Info.h
 * @brief   Declares the kRc940Info class and related types. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_RC940_INFO_H
#define K_FIRESYNC_RC940_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kRc940Info
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the RC940 camera model. 
 */
//typedef kCameraInfo kRc940Info;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kRc940Info object.
 *
 * @public                  @memberof kRc940Info
 * @param   info            Destination for the constructed object handle. 
 * @param   capabilities    Camera algorithm capabilities. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kRc940Info_Construct(kRc940Info* info, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kRc940Info.x.h>

#endif
