/** 
 * @file    kLc900xInfo.h
 * @brief   Declares the kLc900xInfo class and related types. 
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC900X_INFO_H
#define K_FIRESYNC_LC900X_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kLc900xInfo
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the LC900x camera model. 
 */
//typedef kCameraInfo kLc900xInfo;             --forward-declared in kFsDef.x.h

/** 
* Constructs a kLc900xInfo object.
*
* @public                  @memberof kLc900xInfo
* @param   info            Destination for the constructed object handle. 
* @param   model           Camera model. 
* @param   capabilities    Camera algorithm capabilities. 
* @param   allocator       Memory allocator (or kNULL for default). 
* @return                  Operation status. 
*/
kFsFx(kStatus) kLc900xInfo_Construct(kLc900xInfo* info, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kLc900xInfo.x.h>

#endif
