/** 
 * @file    kCameraTracking.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_TRACKING_X_H
#define K_FIRESYNC_CAMERA_TRACKING_X_H

typedef struct kCameraTrackingClass
{
    kCameraExtClass base; 
    k32u searchThreshold; 
    kArrayList inputPorts;
} kCameraTrackingClass; 

kDeclareClassEx(kFs, kCameraTracking, kCameraExt)

/** 
 * Constructs a kCameraTracking object.
 *
 * @public              @memberof kCameraTracking
 * @param   extension    Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) xkCameraTracking_Construct(kCameraTracking* extension, kAlloc allocator); 

kFsFx(kStatus) kCameraTracking_Init(kCameraTracking extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kCameraTracking_VRelease(kCameraTracking extension); 

kFsFx(kStatus) kCameraTracking_ComposeInputPorts(kCameraTracking extension); 

kFsFx(kStatus) kCameraTracking_VClone(kCameraTracking extension, kCameraTracking other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kCameraTracking_VRead(kCameraTracking extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraTracking_VWrite(kCameraTracking extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraTracking_VerificationLabel(kCameraTracking extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kCameraTracking_VVerify(kCameraTracking extension); 

kFsFx(kStatus) kCameraTracking_VNextStates(kCameraTracking extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(k64u) kCameraTracking_VMinimumPeriod(kCameraTracking extension); 

kFsFx(kSize) kCameraTracking_VInputPortCount(kCameraTracking extension); 
kFsFx(kStatus) kCameraTracking_VInputPortInfo(kCameraTracking extension, kSize index, kPortInfo* info);  

kFsFx(kBool) kCameraTracking_VIsInterruptRequired(kCameraTracking extension); 

#define kCameraTracking_SearchThreshold_(S)    (xkCameraTracking_CastRaw(S)->searchThreshold)

#endif
