/** 
 * @file    kCameraExt.h
 * @brief   Declares the kCameraExt type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_EXT_H
#define K_FIRESYNC_CAMERA_EXT_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kCameraExt
 * @extends kObject
 * @ingroup kFireSync-Client-Camera-Extensions
 * @brief   Abstract base class for camera control extension parameters. 
 * 
 * Note to implementers: kCameraExt and its derived types are used in both client and server/hardware contexts. 
 * This approach reduces code duplication, but imposes some complexity/limitations on the implementation. 
 * Because these types can be used separately from the kFireSync/Client object hierarchy, it cannot be assumed 
 * that a sequence object has a reference to its client-side parent (kCamera). 
 */
//typedef kObject kCameraExt;             --forward-declared in kFsDef.x.h

/** 
 * Enables or disables the extension. 
 *
 * @public              @memberof kCameraExt
 * @param   extension   Extension object.  
 * @param   enable      Specifies whether to enable or disable the extension.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kCameraExt_Enable(kCameraExt extension, kBool enable);

/** 
 * Reports whether the extension is currently enabled. 
 *
 * @public              @memberof kCameraExt
 * @param   extension   Extension object.  
 * @return              Returns whether the extension is currently enabled. 
 */
kFsFx(kBool) kCameraExt_IsEnabled(kCameraExt extension);

#include <kFireSync/Client/Camera/Extensions/kCameraExt.x.h>

#endif
