/** 
 * @file    kAlgInfo.h
 * @brief   Declares the kAlgInfo type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ALG_INFO_H
#define K_FIRESYNC_ALG_INFO_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kAlgInfo
 * @extends kObject
 * @ingroup kFireSync-Client-Camera-Algorithms
 * @brief   Abstract base class for camera algorithm parameters. 
 * 
 * Note to implementers: kAlgInfo and its derived types are used in both client and server/hardware contexts. 
 * This approach reduces code duplication, but imposes some complexity/limitations on the implementation. 
 * Because these types can be used separately from the kFireSync/Client object hierarchy, it cannot be assumed 
 * that an algorithm object has a reference to its client-side parent (kCameraState). 
 */
//typedef kObject kAlgInfo;             --forward-declared in kFsDef.x.h

/** 
 * Imports settings to an existing algorithm info object based on the given XML content. 
 *
 * @public              @memberof kAlgInfo
 * @param   info        Algorithm info object. 
 * @param   xml         XML object. 
 * @param   item        XML content item. 
 * @return              Operation status. 
 */
kFsFx(kStatus) kAlgInfo_Import(kAlgInfo info, kXml xml, kXml item); 

/** 
 * Exports settings from an algorithm info object to the given XML object. 
 *
 * Unlike the kAlgInfo_Save function, this function does not write the type metadata that would be 
 * required to later parse the XML content using the kAlgInfo_Load function. 
 *
 * @public              @memberof kAlgInfo
 * @param   info        Algorithm info object. 
 * @param   xml         XML object. 
 * @param   item        XML content item. 
 * @return              Operation status. 
 */
kFsFx(kStatus) kAlgInfo_Export(kAlgInfo info, kXml xml, kXml item); 

#include <kFireSync/Client/Camera/Algorithms/kAlgInfo.x.h>

#endif
