/** 
 * @file    kAccgd2kInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ACCGD2K_INFO_X_H
#define K_FIRESYNC_ACCGD2K_INFO_X_H

typedef struct kAccgd2kInfoClass
{
    kAcgInfoClass base; 
} kAccgd2kInfoClass; 

kDeclareClassEx(kFs, kAccgd2kInfo, kAcgInfo)

kFsFx(kStatus) xkAccgd2kInfo_ConstructFramework(kAccgd2kInfo* info, kAlloc allocator);

kFsFx(kStatus) kAccgd2kInfo_Init(kAccgd2kInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kAlloc alloc); 

kFsFx(kStatus) kAccgd2kInfo_VInitRead(kAccgd2kInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kXml xml, kXmlItem item, kAlloc alloc);

kFsFx(kCameraAlgorithm) kAccgd2kInfo_VId(kAccgd2kInfo info); 
kFsFx(kType) kAccgd2kInfo_VItemType(kAccgd2kInfo info); 

/* 
* Deprecated (Stage 1): not recommended for further use, but not yet announced via kDeprecate
*/

//Deprecated: use kAcgInfo_EnableRanges
#define kAccgd2kInfo_EnableRanges kAcgInfo_EnableRanges
//kDeprecate(kAccgd2kInfo_EnableRanges)

//Deprecated: use kAcgInfo_RangesEnabled
#define kAccgd2kInfo_RangesEnabled kAcgInfo_RangesEnabled
//kDeprecate(kAccgd2kInfo_RangesEnabled)

//Deprecated: use kAcgInfo_RangesEnabledInfo
#define kAccgd2kInfo_RangesEnabledInfo kAcgInfo_RangesEnabledInfo
//kDeprecate(kAccgd2kInfo_RangesEnabledInfo)

//Deprecated: use kAccgd2kInfo_SetEdgeThreshold
#define kAccgd2kInfo_SetThreshold1 kAccgd2kInfo_SetEdgeThreshold
//kDeprecate(kAccgd2kInfo_SetThreshold1)

//Deprecated: use kAccgd2kInfo_EdgeThreshold
#define kAccgd2kInfo_Threshold1 kAccgd2kInfo_EdgeThreshold
//kDeprecate(kAccgd2kInfo_Threshold1)

//Deprecated: use kAccgd2kInfo_EdgeThresholdInfo
#define kAccgd2kInfo_Threshold1Info kAccgd2kInfo_EdgeThresholdInfo
//kDeprecate(kAccgd2kInfo_Threshold1Info)

#endif
