/** 
 * @file    kTimerBlock.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TIMER_BLOCK_X_H
#define K_FIRESYNC_TIMER_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kTimerBlockClass
{
    kPxBlockClass base; 
    kTimerBlockInfo info;           //Settings. 
    kPxPort outputPort;             //Output port for timer messages. 
    kPeriodic timer;                //Periodic timer thread.
    k64u frameCount;                //Frame counter for output messages.  
} kTimerBlockClass; 

kDeclareClassEx(kFs, kTimerBlock, kPxBlock)

kFsFx(const kChar*) kTimerBlock_VDescription(); 

kFsFx(kStatus) kTimerBlock_VOnSetup(kTimerBlock block);
kFsFx(kStatus) kTimerBlock_VOnStart(kTimerBlock block);
kFsFx(kStatus) kTimerBlock_VOnEngage(kTimerBlock block);
kFsFx(kStatus) kTimerBlock_VOnStop(kTimerBlock block);

kFsFx(kStatus) kTimerBlock_OnTimer(kTimerBlock block, kPeriodic timer);

#endif
