/** 
 * @file    kBinCSum4BlockInfo.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_BIN_CSUM4_BLOCK_INFO_X_H
#define K_FIRESYNC_BIN_CSUM4_BLOCK_INFO_X_H

#define kBIN_CSUM4_BLOCK_DFEAULT_BACKGROUND_WIDTH         (32)

typedef struct kBinCSum4BlockInfoClass
{
    kObjectClass base; 
    k32u binThreshold;           
    k32u csumThreshold; 
    kSize backgroundWidth; 
    kSize activePipeCount; 
} kBinCSum4BlockInfoClass; 

kDeclareClassEx(kFs, kBinCSum4BlockInfo, kObject)
        
kFsFx(kStatus) kBinCSum4BlockInfo_Init(kBinCSum4BlockInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kBinCSum4BlockInfo_VRelease(kBinCSum4BlockInfo info); 


#endif
