/** 
 * @file    kMemoryTrafficWorker.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_WORKER_X_H
#define K_FIRESYNC_MEMORY_TRAFFIC_WORKER_X_H

#include <kApi/Data/kArray1.h>

typedef struct kMemoryTrafficWorkerClass 
{
    kObjectClass base;
    kSize threadCount;  
    kSize bufferSize;
    kArray1 threads;
    k64u byteCount;
    k64u duration;
    k64f throughput;
    kAtomic32s shouldQuit;
    kMemoryTrafficOp operation;
    kMemoryTrafficActionInfo info;
    k64u temp;
} kMemoryTrafficWorkerClass;

kDeclareClassEx(kFs, kMemoryTrafficWorker, kObject) 

kFsFx(kStatus) kMemoryTrafficWorker_Init(kMemoryTrafficWorker worker, kType type, kSize bufferSize, kMemoryTrafficOp operation, kSize threadCount, kAlloc allocator);
kFsFx(kStatus) kMemoryTrafficWorker_VRelease(kMemoryTrafficWorker worker);

kFsFx(kStatus) kMemoryTrafficWorker_Read(kMemoryTrafficWorker worker, kSize bufferSize);
kFsFx(kStatus) kMemoryTrafficWorker_Write(kMemoryTrafficWorker worker, kSize bufferSize);
kFsFx(kStatus) kMemoryTrafficWorker_Copy(kMemoryTrafficWorker worker, kSize bufferSize);

kFsFx(kStatus) kMemoryTrafficWorker_ProcessThread(kMemoryTrafficWorker worker);

#endif
