/** 
 * @file    kAxEnviron.h
 * @brief   Declares the kAxEnviron interface. 
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_AX_ENVIRON_H
#define K_FIRESYNC_AX_ENVIRON_H

#include <kFireSync/kNodeDef.h>

/**
 * @interface   kAxEnviron
 * @ingroup     kFireSync-Action
 * @brief       Represents an object that provides external services to an activity object.
 */
//typedef kObject kAxEnviron;            --forward-declared in kFsDef.x.h  

/** 
 * Gets a reference to a kNode object representing the local node. 
 *
 * @public                  @memberof kAxEnviron
 * @param   actionEnviron   Environment provider. 
 * @return                  Local node object. 
 */
kFsFx(kNode) kAxEnviron_Node(kAxEnviron actionEnviron);

/** 
 * Gets a reference to a kSystem object representing the collection of discovered nodes. 
 *
 * @public                  @memberof kAxEnviron
 * @param   actionEnviron   Environment provider. 
 * @return                  System object.
 */
kFsFx(kObject) kAxEnviron_System(kAxEnviron actionEnviron);

#include <kFireSync/Action/kAxEnviron.x.h>

#endif
