#ifndef GV_PROFILE_MSG_X_H
#define GV_PROFILE_MSG_X_H

#include <GoVision/GvDef.h>
#include <GoVision/GvUtils.h>
#include <kFireSync/Data/kMsgSet.h>
#include <kFireSync/Data/kProfileMsg.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArrayList.h>

typedef struct GvProfileMsgClass
{
    GvDataMsgClass base;
    kProfileMsg unresampledMsg;

    // GOC-13342: Array[N-1] of k32u of index value into the merged profile array that indicates the starting
    // location of each of the N-1 buddy sensor profiles (for a N sensor configuration where there is 1 main
    // sensor and N-1 buddy sensors). The starting location of the main sensor's profile is always
    // at index 0, so the main sensor's profile's starting location is not stored in this table.
    // The index values are all 0-based.
    //
    // Set this member variable to kNULL if this information is not available/applicable for this profile
    // message.
    kArray1 profileStartTable;
} GvProfileMsgClass; 

kDeclareClassEx(Gv, GvProfileMsg, GvDataMsg)

typedef k32s GvProfileMsg_PoseId;

GvFx(kStatus) GvProfileMsg_Init(GvProfileMsg msg, kType type, kType pointType, kSize count, kSize pointCount, kAlloc allocator);
GvFx(kStatus) GvProfileMsg_VInitClone(GvProfileMsg msg, GvProfileMsg src, kAlloc alloc);
GvFx(kStatus) GvProfileMsg_VRelease(GvProfileMsg msg);

GvFx(kStatus) GvProfileMsg_WriteDat6V0(GvProfileMsg msg, kSerializer serializer);
GvFx(kStatus) GvProfileMsg_ReadDat6V0(GvProfileMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvProfileMsg_WriteDat6V1(GvProfileMsg msg, kSerializer serializer);
GvFx(kStatus) GvProfileMsg_ReadDat6V1(GvProfileMsg msg, kSerializer serializer, kAlloc allocator);

GvFx(kStatus) GvProfileMsg_FromDataMsg(GvProfileMsg* msg, GvDataMsg src, kAlloc alloc);

GvFx(kStatus) GvProfileMsg_FromKProfileMsg(GvProfileMsg* msg, kProfileMsg src, kBool attachLayers, kBool includeIntensity, k16u savedStampStatus, k16s adjustPointsCount, kAlloc alloc);
GvFx(kStatus) GvProfileMsg_SetUnresampledMsg(GvDataMsg msg, kObject unresampled);
GvFx(kProfileMsg) GvProfileMsg_UnresampledMsg(GvDataMsg msg);

GvFx(const kPoint3d64f*) GvProfileMsg_OffsetAt(GvProfileMsg msg, kSize frame);
GvFx(kStatus) GvProfileMsg_SetOffsetAt(GvProfileMsg msg, kSize frame, const kPoint3d64f* offset);

GvFx(const kPoint3d64f*) GvProfileMsg_ScaleAt(GvProfileMsg msg, kSize frame);
GvFx(kStatus) GvProfileMsg_SetScaleAt(GvProfileMsg msg, kSize frame, const kPoint3d64f* scale);

GvFx(k64u) GvProfileMsg_TimeAt(GvProfileMsg msg, kSize frame);
GvFx(kStatus) GvProfileMsg_SetTimeAt(GvProfileMsg msg, kSize frame, k64u time);

GvFx(k64u) GvProfileMsg_PtpTimeAt(GvProfileMsg msg, kSize frame);
GvFx(kStatus) GvProfileMsg_SetFsAndPtpTimeAt(GvProfileMsg msg, kSize frame, k64u time, k64u ptpTime);

GvFx(k64s) GvProfileMsg_EncoderAt(GvProfileMsg msg, kSize frame);
GvFx(kStatus) GvProfileMsg_SetEncoderAt(GvProfileMsg msg, kSize frame, k64s encoder);

GvFx(kSize) GvProfileMsg_PointCountAt(GvProfileMsg msg, kSize frame);

GvFx(kStatus) GvProfileMsg_SetRangesAt(GvProfileMsg msg, kSize frame, kArray1 ranges);
GvFx(kArray1) GvProfileMsg_RangesAt(GvProfileMsg msg, kSize frame);
GvFx(const void*) GvProfileMsg_RangeAt(GvProfileMsg msg, kSize frame, kSize point);

GvFx(kStatus) GvProfileMsg_SetIntensitiesAt(GvProfileMsg msg, kSize frame, kArray1 intensities);
GvFx(kArray1) GvProfileMsg_IntensitiesAt(GvProfileMsg msg, kSize frame);
GvFx(const k8u*) GvProfileMsg_IntensityAt(GvProfileMsg msg, kSize frame, kSize point);

GvFx(kStatus) GvProfileMsg_SetMapAt(GvProfileMsg msg, kSize frame, kArray1 map);
GvFx(kArray1) GvProfileMsg_MapAt(GvProfileMsg msg, kSize frame);
GvFx(const k8u*) GvProfileMsg_MapValueAt(GvProfileMsg msg, kSize frame, kSize point);
GvFx(kBool) GvProfileMsg_HasMap(GvProfileMsg msg);

GvFx(kStatus) GvProfileMsg_SetSlicesAt(GvProfileMsg msg, kSize frame, kArray1 slices);
GvFx(kArray1) GvProfileMsg_SliceAt(GvProfileMsg msg, kSize frame);
GvFx(kBool) GvProfileMsg_HasSlices(GvProfileMsg msg);
GvFx(const k16u*) GvProfileMsg_SliceValueAt(GvProfileMsg msg, kSize frame, kSize point);

GvFx(kStatus) GvProfileMsg_AddPoseAt(GvProfileMsg msg, kSize frame, const kPose2d64f* pose, GvProfileMsg_PoseId id);
GvFx(kStatus) GvProfileMsg_SelectPoseAt(GvProfileMsg msg, kSize frame, GvProfileMsg_PoseId toId, kPose2d64f* pose);
GvFx(kStatus) GvProfileMsg_SelectPoseInverseAt(GvProfileMsg msg, kSize frame, GvProfileMsg_PoseId fromId, kPose2d64f* pose);
GvFx(kStatus) GvProfileMsg_SelectPoseRelativeAt(GvProfileMsg msg, kSize frame, GvProfileMsg_PoseId toId, GvProfileMsg_PoseId fromId, kPose2d64f* pose);
GvFx(kStatus) GvProfileMsg_AssignPoseAt(GvProfileMsg dstMsg, kSize dstFrame, kMsgSet srcMsg, kSize srcFrame, kAlloc allocator);

GvFx(kSize) GvProfileMsg_PoseCountAt(GvProfileMsg msg, kSize frame);
GvFx(kStatus) GvProfileMsg_PoseAt(GvProfileMsg msg, kSize frame, kSize index, kPose2d64f* pose, GvProfileMsg_PoseId* id);
GvFx(kStatus) GvProfileMsg_SetPoseAt(GvProfileMsg msg, kSize frame, kSize index, kPose2d64f* pose, GvProfileMsg_PoseId id);

/** 
 * Creates a new message by taking the selected frame indices from a batched message.
 *
 * @public              @memberof GvProfileMsg
 * @param   msg         Message object. 
 * @param   output      Pointer to receive the new object.
 * @param   start       First selected index.
 * @param   count       Number of selected indices.
 * @param   alloc       Allocator used to construct the new object.
 * @return              Operation status.
 */
GvFx(kStatus) GvProfileMsg_FrameSlice(GvProfileMsg msg, GvProfileMsg* output, kSize start, kSize count, kAlloc alloc);

#endif  // GV_PROFILE_MSG_X_H
