/** 
 * @file    GvFeature.h
 * @brief   GoVision feature header. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef GV_FEATURE_H
#define GV_FEATURE_H

#include <GoVision/GvDef.h>
#include <GoVision/GvUtils.h>

typedef GvProtoFeature GvFeature;
typedef GvFeature GvFeaturePoint;
typedef GvFeature GvFeaturePlane;
typedef GvFeature GvFeatureLine;

typedef GvProtoFeatureCircle GvFeatureCircle;

GvFx(kSize) GvUtils_ProtoFeatureSize(GvFeatureType featureType);
GvFx(GvFeatureType) GvUtils_ProtoFeatureType(const void* feature);
GvFx(kStatus) GvFeature_ToPoint(const GvFeaturePoint* feature, kPoint3d64f* position);
GvFx(kStatus) GvFeature_FromPoint(GvFeaturePoint* feature, const kPoint3d64f* position);
GvFx(kStatus) GvFeature_ToLine(const GvFeatureLine* feature, kPoint3d64f* point, kPoint3d64f* direction);
GvFx(kStatus) GvFeature_FromLine(GvFeatureLine* feature, const kPoint3d64f* point, const kPoint3d64f* direction);
GvFx(kStatus) GvFeature_ToPlane(const GvFeaturePlane* feature, k64f* originDistance, kPoint3d64f* normal);
GvFx(kStatus) GvFeature_FromPlane(GvFeaturePlane* feature, const k64f originDistance, const kPoint3d64f* normal);
GvFx(kStatus) GvFeature_ToCircle(const GvFeatureCircle* feature, kPoint3d64f* position, k64f* radius, kPoint3d64f* normal);
GvFx(kStatus) GvFeature_FromCircle(GvFeatureCircle* feature, const kPoint3d64f* position, const k64f radius, const kPoint3d64f* normal);

#endif
