#ifndef GSA_LIB_SENSOR_BASE_PROPERTIES_H
#define GSA_LIB_SENSOR_BASE_PROPERTIES_H

#include <GoSensorAppLib/GsaDef.h>
#include <GoApi/Properties/Nodes.h>
#include <GoSensorAppLib/StudioProtocol/Properties/Common.h>

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct ActiveArea : public GoProp::Structure
{
    MinMaxValue<k64f> x;
    MinMaxValue<k64f> y;
    MinMaxValue<k64f> z;
    MinMaxValue<k64f> width;
    MinMaxValue<k64f> length;
    MinMaxValue<k64f> depth;

    ActiveArea()
    {
        Register("x", x);
        Register("y", y);
        Register("z", z);
        Register("width", width);
        Register("length", length);
        Register("depth", depth);
    }
};

struct Transform : public GoProp::Structure
{
    GoProp::Value<k64f> x;
    GoProp::Value<k64f> y;
    GoProp::Value<k64f> z;
    GoProp::Value<k64f> width;
    GoProp::Value<k64f> length;
    GoProp::Value<k64f> height;

    Transform()
    {
        Register("x", x);
        Register("y", y);
        Register("z", z);
        Register("width", width);
        Register("length", length);
        Register("height", height);
    }
};

struct Window : public GoProp::Structure
{
    GoProp::Value<k32s> x;
    GoProp::Value<k32s> y;
    GoProp::Value<k32s> width;
    GoProp::Value<k32s> length;

    Window()
    {
        Register("x", x);
        Register("y", y);
        Register("width", width);
        Register("length", length);
    }

};

struct Camera : public GoProp::Structure
{
    GoProp::Array<Window> windows;

    MinMaxValue<k64f> analogGain;
    MinMaxValue<k64f> digitalGain;

    GoProp::Value<k32s> gammaType;
    GoProp::Value<bool> gammaTypeUsed;
    GoProp::Value<std::vector<k32s>> gammaTypeOptions;

    Camera()
    {
        Register("windows", windows);

        Register("analogGain", analogGain);
        Register("digitalGain", digitalGain);

        Register("gammaType", gammaType);
        gammaType.RegisterSchema("used", gammaTypeUsed);
        gammaType.RegisterSchema("enum", gammaTypeOptions);
    }
};

struct SensorBase : public GoProp::Structure
{
    GoProp::Value<k32s> _serialNumber;
    GoProp::Value<k32s> _connectionStatus;
    GoProp::Value<std::vector<k32s>> _connectionStatusOptions;

    GoProp::Value<bool> _initailized;

    ActiveArea activeArea;
    Transform transform;

    GoProp::Value<k32s> xSubsampling;
    GoProp::Value<std::vector<k32s>> xSubsamplingOptions;

    GoProp::Value<k32s> zSubsampling;
    GoProp::Value<std::vector<k32s>> zSubsamplingOptions;

    GoProp::Value<k32s> exposureMode;
    GoProp::Value<std::vector<k32s>> exposureModeOptions;

    MinMaxValue<k64f> singleExposure;

    GoProp::Value<std::vector<k64f>> multipleExposures;
    GoProp::Value<k64f> multipleExposuresMin;
    GoProp::Value<k64f> multipleExposuresMax;
    GoProp::Value<k64u> multipleExposuresMinCount;
    GoProp::Value<k64u> multipleExposuresMaxCount;

    GoProp::Value<k64f> dynamicExposureMin;
    GoProp::Value<k64f> dynamicExposureMax;

    MinMaxValue<k64f> dynamicSensitivity;
    MinMaxValue<k32u> dynamicThreshold;

    GoProp::Array<Camera> cameras;
    GoProp::Value<bool> sensitivityCompensationEnabled;

    SensorBase()
    {
        Register("_serialNumber", _serialNumber);
        _connectionStatusOptions.Set({ 0,1,2,3,4,5 });
        _connectionStatus.RegisterSchema("enum", _connectionStatusOptions);
        Register("_connectionStatus", _connectionStatus);
        Register("_initialized", _initailized);

        Register("activeArea", activeArea);
        Register("transform", transform);

        xSubsamplingOptions.Set({ 1,2,4 });
        Register("xSubsampling", xSubsampling);
        xSubsampling.RegisterSchema("enum", xSubsamplingOptions);

        zSubsamplingOptions.Set({ 1,2,4 });
        Register("zSubsampling", zSubsampling);
        zSubsampling.RegisterSchema("enum", zSubsamplingOptions);

        exposureModeOptions.Set({ 0,1,2 });
        Register("exposureMode", exposureMode);
        exposureMode.RegisterSchema("enum", exposureModeOptions);

        Register("singleExposure", singleExposure);

        Register("multipleExposures", multipleExposures);
        multipleExposures.RegisterSchema("minimum", multipleExposuresMin);
        multipleExposures.RegisterSchema("maximum", multipleExposuresMax);
        multipleExposures.RegisterSchema("minItems", multipleExposuresMinCount);
        multipleExposures.RegisterSchema("maxItems", multipleExposuresMaxCount);

        Register("dynamicExposureMin", dynamicExposureMin);
        Register("dynamicExposureMax", dynamicExposureMax);

        Register("dynamicSensitivity", dynamicSensitivity);
        Register("dynamicThreshold", dynamicThreshold);

        Register("cameras", cameras);
        Register("sensitivityCompensationEnabled", sensitivityCompensationEnabled);
    }
};

}; // namespace

#endif
