/** 
 * @file    TestSurfaceGraphics.c
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef TOOL_TEST_SURFACE_GRAPHICS_TOOL_Z_H
#define TOOL_TEST_SURFACE_GRAPHICS_TOOL_Z_H

#define TEST_SURFACE_GRAPHICS_TOOL_NAME        "TestSurfaceGraphicsTool"
#define TEST_SURFACE_GRAPHICS_TOOL_LABEL       "Test Surface Graphics"

typedef enum TestSurfaceGraphicsMeasurement
{
    TEST_SURFACE_GRAPHICS_MEASUREMENT_POINT = 0,
    TEST_SURFACE_GRAPHICS_MEASUREMENT_LINE = 1
}TestSurfaceGraphicsMeasurement;

typedef struct TestSurfaceGraphicsClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;
    
    GdkRegion3d64f region;    
    k32f startSize;
    k32f stepSize;
} TestSurfaceGraphicsClass;

kDeclareClassEx(Tool, TestSurfaceGraphics, GdkTool)

ToolFx(kStatus) TestSurfaceGraphics_VDescribe(GdkToolInfo info);

ToolFx(kStatus) TestSurfaceGraphics_VInit(TestSurfaceGraphics tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestSurfaceGraphics_VRelease(TestSurfaceGraphics tool);
ToolFx(kStatus) TestSurfaceGraphics_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestSurfaceGraphics_VStart(TestSurfaceGraphics tool);
ToolFx(kStatus) TestSurfaceGraphics_VStop(TestSurfaceGraphics tool);
ToolFx(kStatus) TestSurfaceGraphics_VProcess(TestSurfaceGraphics tool, GdkToolInput input, GdkToolOutput output);
ToolFx(kStatus) TestSurfaceGraphics_OutputValue(GdkToolOutput output, kSize index, k64f value, GdkMeasurementDecision decision, GdkToolCfg config);

#endif
