/**
 * @file    TestMesh.x.h
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef GDK_TEST_MESH_TOOL_X_H
#define GDK_TEST_MESH_TOOL_X_H

#define TEST_MESH_TOOL_NAME            "TestMeshToolOutput"
#define TEST_MESH_TOOL_LABEL_FEATURE   "Test Mesh Output"

typedef struct TestMeshClass
{
    GdkToolClass base;

    k64f radius;
    kSize longitudeCount;
    kSize latitudeCount;

    kSize facetCount;

} TestMeshClass;

kDeclareClassEx(Tool, TestMesh, GdkTool)

ToolFx(const kChar*) TestMesh_VName();
ToolFx(kStatus) TestMesh_VDescribe(GdkToolInfo info);

ToolFx(kStatus) TestMesh_VInit(TestMesh tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestMesh_VRelease(TestMesh tool);
ToolFx(kStatus) TestMesh_VCalcDataOutputRegionInstanced(GdkTool tool, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);
ToolFx(kStatus) TestMesh_VUpdateConfigInstanced(TestMesh tool, GdkToolCfg toolConfig);
ToolFx(kStatus) TestMesh_VStart(TestMesh tool);
ToolFx(kStatus) TestMesh_VProcess(TestMesh tool, GdkToolInput input, GdkToolOutput output);

ToolFx(kStatus) TestMesh_GenerateUvSphere(TestMesh tool, GvMeshMsg msg);

ToolFx(kStatus) TestMesh_CalculateNormals(TestMesh tool, GvMeshMsg meshMsg);
ToolFx(kStatus) TestMesh_AddCurvature(TestMesh tool, GvMeshMsg meshMsg);
ToolFx(kStatus) TestMesh_AddTexture(TestMesh tool, GvMeshMsg meshMsg);

ToolFx(kStatus) TestMesh_Add3d32f(kPoint3d32f *p1, kPoint3d32f *p2, kPoint3d32f *sum);
ToolFx(kStatus) TestMesh_Sub3d32f(kPoint3d32f *p1, kPoint3d32f *p2, kPoint3d32f *diff);
ToolFx(kStatus) TestMesh_CrossProduct3d32f(kPoint3d32f *p1, kPoint3d32f *p2, kPoint3d32f *cproduct);
ToolFx(kStatus) TestMesh_Normalize3d32f(kPoint3d32f *vector);
ToolFx(kStatus) TestMesh_CalculateFacetNormal(kPoint3d32f *p1, kPoint3d32f *p2, kPoint3d32f *p3, kPoint3d32f *normal);

#endif //GT_TEST_MESH_TOOL_X_H
