/** 
 * @file    TestFeatureAverage.x.h
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef GDK_SURFACE_LINE_AVERAGE_TOOL_X_H
#define GDK_SURFACE_LINE_AVERAGE_TOOL_X_H

#include <kVision/S3d/kS3dUtilities.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dLinePalette.h>
#include <kVision/L3d/kL3dUtilities.h>

#define GDK_SURFACE_LINE_AVERAGE_TOOL_NAME "TestFeatureAverage"
#define GDK_SURFACE_LINE_AVERAGE_TOOL_LABEL "Test Feature Average"

#define EPSILON 1e-20

#define NUM_FEATURES_TO_DRAW 3

#define OUTPUT_MEASURE_INDEX_X      0
#define OUTPUT_MEASURE_INDEX_Y      1
#define OUTPUT_MEASURE_INDEX_Z      2
#define OUTPUT_MEASURE_INDEX_ZAngle 3
#define OUTPUT_FEATURE_INDEX_POINT  4
#define OUTPUT_FEATURE_INDEX_LINE   5

#define ABS(a) ((a)>=0 ? (a) : -(a))

typedef struct TestFeatureAverageClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;

} TestFeatureAverageClass;

kDeclareClassEx(Tool, TestFeatureAverage, GdkTool)

ToolFx(const kChar*) TestFeatureAverage_VName();
ToolFx(kStatus) TestFeatureAverage_VDescribe(GdkToolInfo info);
ToolFx(kStatus) TestFeatureAverage_VStart(TestFeatureAverage tool);
ToolFx(kStatus) TestFeatureAverage_VStop(TestFeatureAverage tool);
ToolFx(kStatus) TestFeatureAverage_VProcess(TestFeatureAverage tool, GdkToolInput input, GdkToolOutput output);
ToolFx(kStatus) TestFeatureAverage_VInit(TestFeatureAverage tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestFeatureAverage_VRelease(TestFeatureAverage tool);
ToolFx(kStatus) TestFeatureAverage_VNewToolConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestFeatureAverage_VNewMeasurementConfig(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
ToolFx(kStatus) TestFeatureAverage_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);

// Outputs
ToolFx(kStatus) TestFeatureAverage_OutputValue(GdkToolOutput output, kSize index, k64f value, GdkMeasurementDecision decision, GdkToolCfg config);
ToolFx(kStatus) TestFeatureAverage_SendFeatureLine(TestFeatureAverage tool, GdkToolOutput output, kSize index, const kLine3d64f* inLine);
ToolFx(kStatus) TestFeatureAverage_SendFeaturePoint(TestFeatureAverage tool, GdkToolOutput output, kSize index, const kPoint3d64f* inPt);
ToolFx(kStatus) TestFeatureAverage_DrawPoint(GdkGraphic graphic, GdkToolOutput output, const kPoint3d64f* pt, kColor color, kAlloc alloc);
ToolFx(kStatus) TestFeatureAverage_DrawLine(GdkGraphic graphic, GdkToolOutput output, const kLine3d64f* line, kColor color, const GdkRegion3d64f* globalRegion, kAlloc alloc);

// Points and Vectors
ToolFx(kStatus)     TestFeatureAverage_AveragePointPoint(kPoint3d64f pt1, kPoint3d64f pt2, kPoint3d64f* outAvgPoint);
ToolFx(kStatus)     TestFeatureAverage_AveragePointLine(kPoint3d64f pt, kLine3d64f line, kPoint3d64f* outAvgPoint);
ToolFx(kStatus)     TestFeatureAverage_AverageLineLine(kLine3d64f line1, kLine3d64f line2, kLine3d64f* outAvgLine);
ToolFx(kPoint3d64f) TestFeatureAverage_ScaleVector(k64f scalar, kPoint3d64f vector);
ToolFx(kPoint3d64f) TestFeatureAverage_AddVectors(kPoint3d64f vector1, kPoint3d64f vector2);
ToolFx(kPoint3d64f) TestFeatureAverage_Reverse(kPoint3d64f vector);
ToolFx(kPoint3d64f) TestFeatureAverage_Normalize(kPoint3d64f vector);
ToolFx(kBool)       TestFeatureAverage_EqualVectors(kPoint3d64f vector1, kPoint3d64f vector2);
ToolFx(k64f)        TestFeatureAverage_DotProduct(kPoint3d64f vector1, kPoint3d64f vector2);
ToolFx(kPoint3d64f) TestFeatureAverage_LineSolveForY(kLine3d64f line, k64f y);
ToolFx(kPoint3d64f) TestFeatureAverage_LineSolveForX(kLine3d64f line, k64f x);
ToolFx(kPoint3d32f) TestFeatureAverage_Point64to32(kPoint3d64f pt64);

#endif
