
export K_REGENERATOR := 1
export K_ARM7_VXWORKS_DEBUG_INFO_ENABLED := 0

ifeq ($(OS)$(os), Windows_NT)
	VXW_PATH     := C:/WrsVxw_6.9.4.6
	TOOLS_PATH   := C:/tools/GccArm7_4.9.4-p23
	CROSS_PREFIX := C:/tools/GccArm7_4.9.4-p23/arm-unknown-elf/bin/arm-unknown-elf-
	CROSS_SUFFIX := .exe
	PYTHON       := python
else
	VXW_PATH     := /WrsVxw_6.9.4.6
	TOOLS_PATH   := /tools/GccArm7_4.9.4-p23
	CROSS_PREFIX := /tools/GccArm7_4.9.4-p23/arm-unknown-elf/bin/arm-unknown-elf-
	CROSS_SUFFIX := 
	PYTHON       := python3
endif

C_COMPILER := $(CROSS_PREFIX)gcc$(CROSS_SUFFIX)
CXX_COMPILER := $(CROSS_PREFIX)g++$(CROSS_SUFFIX)
LINKER := $(CROSS_PREFIX)ld$(CROSS_SUFFIX)
ARCHIVER := $(CROSS_PREFIX)ar$(CROSS_SUFFIX)
OBJ_NAMES := $(CROSS_PREFIX)nm$(CROSS_SUFFIX)

TAR_GEN := $(PYTHON) ../../Platform/scripts/Utils/kTarGen.py
MUNCH := $(PYTHON) ../../Platform/scripts/Utils/kMunch.py
MKDIR_P := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py mkdir_p
RM_F := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py rm_f
RM_RF := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py rm_rf
CP := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py cp
KGENERATOR := $(PYTHON) ../../Platform/scripts/Utils/kGenerator.py

ifndef verbose
	SILENT := @
endif

ifndef config
	config := Debug
endif

ifeq ($(word 1, $(subst ., ,$(MAKE_VERSION))), 3)
.PHONY: err
err: ; $(error GNU Make version 3.x is not supported)
endif

# We require tools to be installed according to specific conventions (see manuals).
# Tool prerequisites may change between major releases; check and report.
ifeq ($(shell $(C_COMPILER) --version),)
.PHONY: tc_err
tc_err:
	$(error Cannot build because of missing prerequisite; please install)
endif

ifeq ($(config),Debug)

	TARGET := ../../bin/arm7/GdkAppSample.kext
	INTERMEDIATES := 
	OBJ_DIR := ../../build/GdkAppSample-wrwbmk-Debug
	PREBUILD := 
	POSTBUILD := 
	COMPILER_FLAGS := -O2 -mcpu=cortex-a9 -march=armv7-a -mlong-calls -mfpu=neon -mfloat-abi=softfp -Wall -Wfloat-conversion -fno-zero-initialized-in-bss -Wno-missing-braces
	C_FLAGS := -std=gnu99 -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value
	INCLUDE_DIRS := -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	DEFINES := -D_WRS_KERNEL -DK_PLUGIN -DGO_GDK_DYNAMIC -DGDKAPP
	CXX_FLAGS := -std=c++14 -fexceptions -Wno-literal-suffix
	LINKER_FLAGS := -X -EL --strip-debug
	LIB_DIRS := -L$(TOOLS_PATH)/arm-unknown-elf/lib/gcc/arm-unknown-elf/4.9.4 -L$(TOOLS_PATH)/arm-unknown-elf/arm-unknown-elf/lib
	LIBS :=
	OBJECTS := ../../build/GdkAppSample-wrwbmk-Debug/Asm.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestProfileSelect.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestMesh.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceSelect.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceConfiguration.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceGraphics.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceFeatures.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestFeatureAverage.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceDynamicAlignment.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestProfileDynamicAlignment.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestDynamicOutputs.o \
	../../build/GdkAppSample-wrwbmk-Debug/TestGenericInput.o \
	../../build/GdkAppSample-wrwbmk-Debug/GdkPartSegmentResult.o
	DEP_FILES = ../../build/GdkAppSample-wrwbmk-Debug/Asm.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestProfileSelect.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestMesh.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceSelect.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceConfiguration.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceGraphics.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceFeatures.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestFeatureAverage.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceDynamicAlignment.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestProfileDynamicAlignment.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestDynamicOutputs.d \
	../../build/GdkAppSample-wrwbmk-Debug/TestGenericInput.d \
	../../build/GdkAppSample-wrwbmk-Debug/GdkPartSegmentResult.d
	TARGET_DEPS = 

endif

ifeq ($(config),Release)

	TARGET := ../../bin/arm7/GdkAppSample.kext
	INTERMEDIATES := 
	OBJ_DIR := ../../build/GdkAppSample-wrwbmk-Release
	PREBUILD := 
	POSTBUILD := 
	COMPILER_FLAGS := -O2 -mcpu=cortex-a9 -march=armv7-a -mlong-calls -mfpu=neon -mfloat-abi=softfp -Wall -Wfloat-conversion -fno-zero-initialized-in-bss -Wno-missing-braces
	C_FLAGS := -std=gnu99 -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value
	INCLUDE_DIRS := -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	DEFINES := -D_WRS_KERNEL -DK_PLUGIN -DGO_GDK_DYNAMIC -DGDKAPP
	CXX_FLAGS := -std=c++14 -fexceptions -Wno-literal-suffix
	LINKER_FLAGS := -X -EL --strip-debug
	LIB_DIRS := -L$(TOOLS_PATH)/arm-unknown-elf/lib/gcc/arm-unknown-elf/4.9.4 -L$(TOOLS_PATH)/arm-unknown-elf/arm-unknown-elf/lib
	LIBS :=
	OBJECTS := ../../build/GdkAppSample-wrwbmk-Release/Asm.o \
	../../build/GdkAppSample-wrwbmk-Release/TestProfileSelect.o \
	../../build/GdkAppSample-wrwbmk-Release/TestMesh.o \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceSelect.o \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceConfiguration.o \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceGraphics.o \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceFeatures.o \
	../../build/GdkAppSample-wrwbmk-Release/TestFeatureAverage.o \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceDynamicAlignment.o \
	../../build/GdkAppSample-wrwbmk-Release/TestProfileDynamicAlignment.o \
	../../build/GdkAppSample-wrwbmk-Release/TestDynamicOutputs.o \
	../../build/GdkAppSample-wrwbmk-Release/TestGenericInput.o \
	../../build/GdkAppSample-wrwbmk-Release/GdkPartSegmentResult.o
	DEP_FILES = ../../build/GdkAppSample-wrwbmk-Release/Asm.d \
	../../build/GdkAppSample-wrwbmk-Release/TestProfileSelect.d \
	../../build/GdkAppSample-wrwbmk-Release/TestMesh.d \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceSelect.d \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceConfiguration.d \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceGraphics.d \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceFeatures.d \
	../../build/GdkAppSample-wrwbmk-Release/TestFeatureAverage.d \
	../../build/GdkAppSample-wrwbmk-Release/TestSurfaceDynamicAlignment.d \
	../../build/GdkAppSample-wrwbmk-Release/TestProfileDynamicAlignment.d \
	../../build/GdkAppSample-wrwbmk-Release/TestDynamicOutputs.d \
	../../build/GdkAppSample-wrwbmk-Release/TestGenericInput.d \
	../../build/GdkAppSample-wrwbmk-Release/GdkPartSegmentResult.d
	TARGET_DEPS = 

endif

.PHONY: all all-obj all-dep

all: $(OBJ_DIR)
	$(PREBUILD)
	$(SILENT) $(MAKE) -f GdkAppSample-WrWb.mk all-dep
	$(SILENT) $(MAKE) -f GdkAppSample-WrWb.mk all-obj

clean:
	$(info Cleaning $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(info Cleaning $(TARGET) $(INTERMEDIATES))
	$(SILENT) $(RM_F) $(TARGET) $(INTERMEDIATES)

all-obj: $(OBJ_DIR) $(TARGET)
all-dep: $(OBJ_DIR) $(DEP_FILES)

$(OBJ_DIR): GdkAppSample-WrWb.mk
	$(info Cleanse $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(SILENT) $(MKDIR_P) $(OBJ_DIR)

ifeq ($(MAKECMDGOALS),)
ifeq ($(MAKE_RESTARTS),)
GdkAppSample-WrWb.mk: GdkAppSample.xml ../Gdk.xml ../../Platform/scripts/Utils/Generator/WrWbMk.py
	$(info RegenArm7 GdkAppSample-WrWb.mk)
	$(SILENT) $(KGENERATOR) --writers=WrWbMk --platforms=Arm7 --project=GdkAppSample ../Gdk.xml
endif
endif

ifeq ($(config),Debug)

../../bin/arm7/GdkAppSample.kext: $(OBJECTS) $(TARGET_DEPS) ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.o ../../Platform/kHardwareZynq7k/kHardwareZynq7k/Link/dynamic.ld
	$(info LdArm7 ../../bin/arm7/GdkAppSample.kext)
	$(SILENT) $(LINKER) $(LINKER_FLAGS) -r -nostdlib -T../../Platform/kHardwareZynq7k/kHardwareZynq7k/Link/dynamic.ld -o ../../bin/arm7/GdkAppSample.kext ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.o --Map=../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample.map
	$(POSTBUILD)

../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.o: ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.c
	$(info GccArm7 ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.c)
	$(SILENT) $(C_COMPILER) $(COMPILER_FLAGS) $(C_FLAGS) -o ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.o -c ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.c -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.c: ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o
	$(info MunchArm7 ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.c)
	$(SILENT) $(MUNCH) $(OBJ_NAMES) ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-munch.c

../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o: $(OBJECTS) $(TARGET_DEPS)
	$(info LdArm7 ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o)
	$(SILENT) $(LINKER) $(LIB_DIRS) $(LINKER_FLAGS) -r -nostdlib -o ../../build/GdkAppSample-wrwbmk-Debug/GdkAppSample-partial.o $(OBJECTS) $(LIBS)

endif

ifeq ($(config),Release)

../../bin/arm7/GdkAppSample.kext: $(OBJECTS) $(TARGET_DEPS) ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.o ../../Platform/kHardwareZynq7k/kHardwareZynq7k/Link/dynamic.ld
	$(info LdArm7 ../../bin/arm7/GdkAppSample.kext)
	$(SILENT) $(LINKER) $(LINKER_FLAGS) -r -nostdlib -T../../Platform/kHardwareZynq7k/kHardwareZynq7k/Link/dynamic.ld -o ../../bin/arm7/GdkAppSample.kext ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.o --Map=../../build/GdkAppSample-wrwbmk-Release/GdkAppSample.map
	$(POSTBUILD)

../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.o: ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.c
	$(info GccArm7 ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.c)
	$(SILENT) $(C_COMPILER) $(COMPILER_FLAGS) $(C_FLAGS) -o ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.o -c ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.c -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.c: ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o
	$(info MunchArm7 ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.c)
	$(SILENT) $(MUNCH) $(OBJ_NAMES) ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-munch.c

../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o: $(OBJECTS) $(TARGET_DEPS)
	$(info LdArm7 ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o)
	$(SILENT) $(LINKER) $(LIB_DIRS) $(LINKER_FLAGS) -r -nostdlib -o ../../build/GdkAppSample-wrwbmk-Release/GdkAppSample-partial.o $(OBJECTS) $(LIBS)

endif

ifeq ($(config),Debug)

../../build/GdkAppSample-wrwbmk-Debug/Asm.o ../../build/GdkAppSample-wrwbmk-Debug/Asm.d: GdkAppSample/Asm.cpp
	$(info GccArm7 GdkAppSample/Asm.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/Asm.o -c GdkAppSample/Asm.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestProfileSelect.o ../../build/GdkAppSample-wrwbmk-Debug/TestProfileSelect.d: GdkAppSample/TestProfileSelect.cpp
	$(info GccArm7 GdkAppSample/TestProfileSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestProfileSelect.o -c GdkAppSample/TestProfileSelect.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestMesh.o ../../build/GdkAppSample-wrwbmk-Debug/TestMesh.d: GdkAppSample/TestMesh.cpp
	$(info GccArm7 GdkAppSample/TestMesh.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestMesh.o -c GdkAppSample/TestMesh.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceSelect.o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceSelect.d: GdkAppSample/TestSurfaceSelect.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceSelect.o -c GdkAppSample/TestSurfaceSelect.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceConfiguration.o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceConfiguration.d: GdkAppSample/TestSurfaceConfiguration.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceConfiguration.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceConfiguration.o -c GdkAppSample/TestSurfaceConfiguration.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceGraphics.o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceGraphics.d: GdkAppSample/TestSurfaceGraphics.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceGraphics.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceGraphics.o -c GdkAppSample/TestSurfaceGraphics.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceFeatures.o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceFeatures.d: GdkAppSample/TestSurfaceFeatures.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceFeatures.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceFeatures.o -c GdkAppSample/TestSurfaceFeatures.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestFeatureAverage.o ../../build/GdkAppSample-wrwbmk-Debug/TestFeatureAverage.d: GdkAppSample/TestFeatureAverage.cpp
	$(info GccArm7 GdkAppSample/TestFeatureAverage.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestFeatureAverage.o -c GdkAppSample/TestFeatureAverage.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceDynamicAlignment.o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceDynamicAlignment.d: GdkAppSample/TestSurfaceDynamicAlignment.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceDynamicAlignment.o -c GdkAppSample/TestSurfaceDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestProfileDynamicAlignment.o ../../build/GdkAppSample-wrwbmk-Debug/TestProfileDynamicAlignment.d: GdkAppSample/TestProfileDynamicAlignment.cpp
	$(info GccArm7 GdkAppSample/TestProfileDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestProfileDynamicAlignment.o -c GdkAppSample/TestProfileDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestDynamicOutputs.o ../../build/GdkAppSample-wrwbmk-Debug/TestDynamicOutputs.d: GdkAppSample/TestDynamicOutputs.cpp
	$(info GccArm7 GdkAppSample/TestDynamicOutputs.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestDynamicOutputs.o -c GdkAppSample/TestDynamicOutputs.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/TestGenericInput.o ../../build/GdkAppSample-wrwbmk-Debug/TestGenericInput.d: GdkAppSample/TestGenericInput.cpp
	$(info GccArm7 GdkAppSample/TestGenericInput.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/TestGenericInput.o -c GdkAppSample/TestGenericInput.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Debug/GdkPartSegmentResult.o ../../build/GdkAppSample-wrwbmk-Debug/GdkPartSegmentResult.d: GdkAppSample/GdkPartSegmentResult.cpp
	$(info GccArm7 GdkAppSample/GdkPartSegmentResult.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Debug/GdkPartSegmentResult.o -c GdkAppSample/GdkPartSegmentResult.cpp -MMD -MP

endif

ifeq ($(config),Release)

../../build/GdkAppSample-wrwbmk-Release/Asm.o ../../build/GdkAppSample-wrwbmk-Release/Asm.d: GdkAppSample/Asm.cpp
	$(info GccArm7 GdkAppSample/Asm.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/Asm.o -c GdkAppSample/Asm.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestProfileSelect.o ../../build/GdkAppSample-wrwbmk-Release/TestProfileSelect.d: GdkAppSample/TestProfileSelect.cpp
	$(info GccArm7 GdkAppSample/TestProfileSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestProfileSelect.o -c GdkAppSample/TestProfileSelect.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestMesh.o ../../build/GdkAppSample-wrwbmk-Release/TestMesh.d: GdkAppSample/TestMesh.cpp
	$(info GccArm7 GdkAppSample/TestMesh.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestMesh.o -c GdkAppSample/TestMesh.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestSurfaceSelect.o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceSelect.d: GdkAppSample/TestSurfaceSelect.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceSelect.o -c GdkAppSample/TestSurfaceSelect.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestSurfaceConfiguration.o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceConfiguration.d: GdkAppSample/TestSurfaceConfiguration.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceConfiguration.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceConfiguration.o -c GdkAppSample/TestSurfaceConfiguration.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestSurfaceGraphics.o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceGraphics.d: GdkAppSample/TestSurfaceGraphics.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceGraphics.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceGraphics.o -c GdkAppSample/TestSurfaceGraphics.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestSurfaceFeatures.o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceFeatures.d: GdkAppSample/TestSurfaceFeatures.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceFeatures.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceFeatures.o -c GdkAppSample/TestSurfaceFeatures.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestFeatureAverage.o ../../build/GdkAppSample-wrwbmk-Release/TestFeatureAverage.d: GdkAppSample/TestFeatureAverage.cpp
	$(info GccArm7 GdkAppSample/TestFeatureAverage.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestFeatureAverage.o -c GdkAppSample/TestFeatureAverage.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestSurfaceDynamicAlignment.o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceDynamicAlignment.d: GdkAppSample/TestSurfaceDynamicAlignment.cpp
	$(info GccArm7 GdkAppSample/TestSurfaceDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceDynamicAlignment.o -c GdkAppSample/TestSurfaceDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestProfileDynamicAlignment.o ../../build/GdkAppSample-wrwbmk-Release/TestProfileDynamicAlignment.d: GdkAppSample/TestProfileDynamicAlignment.cpp
	$(info GccArm7 GdkAppSample/TestProfileDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestProfileDynamicAlignment.o -c GdkAppSample/TestProfileDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestDynamicOutputs.o ../../build/GdkAppSample-wrwbmk-Release/TestDynamicOutputs.d: GdkAppSample/TestDynamicOutputs.cpp
	$(info GccArm7 GdkAppSample/TestDynamicOutputs.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestDynamicOutputs.o -c GdkAppSample/TestDynamicOutputs.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/TestGenericInput.o ../../build/GdkAppSample-wrwbmk-Release/TestGenericInput.d: GdkAppSample/TestGenericInput.cpp
	$(info GccArm7 GdkAppSample/TestGenericInput.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/TestGenericInput.o -c GdkAppSample/TestGenericInput.cpp -MMD -MP

../../build/GdkAppSample-wrwbmk-Release/GdkPartSegmentResult.o ../../build/GdkAppSample-wrwbmk-Release/GdkPartSegmentResult.d: GdkAppSample/GdkPartSegmentResult.cpp
	$(info GccArm7 GdkAppSample/GdkPartSegmentResult.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-wrwbmk-Release/GdkPartSegmentResult.o -c GdkAppSample/GdkPartSegmentResult.cpp -MMD -MP

endif

ifeq ($(MAKECMDGOALS),all-obj)

ifeq ($(config),Debug)

include ../../build/GdkAppSample-wrwbmk-Debug/Asm.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestProfileSelect.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestMesh.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceSelect.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceConfiguration.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceGraphics.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceFeatures.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestFeatureAverage.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestSurfaceDynamicAlignment.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestProfileDynamicAlignment.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestDynamicOutputs.d
include ../../build/GdkAppSample-wrwbmk-Debug/TestGenericInput.d
include ../../build/GdkAppSample-wrwbmk-Debug/GdkPartSegmentResult.d

endif

ifeq ($(config),Release)

include ../../build/GdkAppSample-wrwbmk-Release/Asm.d
include ../../build/GdkAppSample-wrwbmk-Release/TestProfileSelect.d
include ../../build/GdkAppSample-wrwbmk-Release/TestMesh.d
include ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceSelect.d
include ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceConfiguration.d
include ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceGraphics.d
include ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceFeatures.d
include ../../build/GdkAppSample-wrwbmk-Release/TestFeatureAverage.d
include ../../build/GdkAppSample-wrwbmk-Release/TestSurfaceDynamicAlignment.d
include ../../build/GdkAppSample-wrwbmk-Release/TestProfileDynamicAlignment.d
include ../../build/GdkAppSample-wrwbmk-Release/TestDynamicOutputs.d
include ../../build/GdkAppSample-wrwbmk-Release/TestGenericInput.d
include ../../build/GdkAppSample-wrwbmk-Release/GdkPartSegmentResult.d

endif

endif

