#ifndef GDK_TOOL_INPUT_Z_H
#define GDK_TOOL_INPUT_Z_H

#include <Gdk/Tools/GdkPointFeature.h>
#include <Gdk/Tools/GdkLineFeature.h>
#include <Gdk/Tools/GdkCircleFeature.h>
#include <Gdk/Tools/GdkPlaneFeature.h>
#include <Gdk/Tools/GdkToolInput.h>
#include <kApi/Data/kArrayList.h>
#include <kFireSync/kNodeDef.h>

typedef struct GdkInputItemClass
{
    GdkDataInfo info;
    GdkFrameInfo frameInfo;
    kPoint3d64f offset;
    GdkTransform3d globalTransform;
    kSize length0;
    kSize length1;
    const void* rangeData;
    const void* intensityData;
    kMsgSet msg;
} GdkInputItemClass;

#define GdkInputItem_Cast_(CONTEXT)  kCast(GdkInputItemClass*, CONTEXT)

typedef struct GdkToolInputDataItem
{
    kSize id; // This input index number is configured from GDK application VDescribe function.
    GdkFeature feature;
    const kChar* name;
    kMsgSet dataMsg;
    GdkDataSource dataSource;
} GdkToolInputDataItem;

typedef struct GdkToolInputAnchorItem
{
    kBool isSet;
    k64f value;
    kPoint3d64f position;
} GdkToolInputAnchorItem;

typedef struct GdkToolInputClass
{
    kObjectClass base;

    GdkToolInputAnchorItem anchorInputs[GDK_ANCHOR_PARAM_COUNT];

    kPoint3d64f anchorPosition;

    // Arrays to store input items depending whether they are identified as standard
    // 2-sensor data sources (legacy) or multi buddied data sources in data grid layout.
    // See GOC-12986.
    GdkInputItem sourceItemsStandard[GDK_DATA_SOURCE_COUNT];
    GdkInputItem sourceItemsDataGrid[GDK_MAX_SENSOR_COUNT];

    GdkDataSource selectedSource;

    kArrayList inputDataItems;
} GdkToolInputClass;

#define GdkToolInputTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkToolInput))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkToolInput_Init(GdkToolInput input, kType type, kAlloc alloc);
GdkFx(kStatus) GdkToolInput_VRelease(GdkToolInput input);

GdkFx(kStatus) GdkToolInput_Construct(GdkToolInput* input, kAlloc alloc);

GdkFx(kStatus) GdkToolInput_Add(GdkToolInput input, GdkDataInfo info, GdkInputItem* item);
GdkFx(kStatus) GdkToolInput_Clear(GdkToolInput input);
GdkFx(kStatus) GdkToolInput_SetSelectedSource(GdkToolInput input, GdkDataSource source);

GdkFx(kStatus) GdkToolInput_AddInputData(GdkToolInput output, const kChar* name, kSize id);
GdkFx(kStatus) GdkToolInput_SetFeatureAt(GdkToolInput input, kSize index, GdkFeature feature);
GdkFx(kStatus) GdkToolInput_SetInputDataMsgAt(GdkToolInput input, kSize index, kMsgSet msg, GdkDataSource source);

GdkFx(kStatus) GdkToolInput_SetAnchorInput(GdkToolInput input, GdkAnchorParam component, k64f value, const kPoint3d64f* position);
GdkFx(kStatus) GdkToolInput_UnsetAnchorInput(GdkToolInput input, GdkAnchorParam component);

GdkFx(kStatus) GdkToolInput_UpdateAnchorOffsets(GdkToolInput input);
GdkFx(kStatus) GdkToolInput_UpdateAnchorOffset(GdkToolInput input, GdkAnchorParam component, k64f* offset);

GdkFx(kStatus) GdkInputItem_SetInputMsg(GdkInputItem input, kMsgSet msg);
GdkFx(kStatus) GdkInputItem_SetOffset(GdkInputItem input, const kPoint3d64f* offset);
GdkFx(kStatus) GdkInputItem_SetGlobalMatrix(GdkInputItem input, const GdkTransform3d* pose);
GdkFx(kStatus) GdkInputItem_SetFrameInfo(GdkInputItem input, kStamp* stamp, k64u* time, k64s* encoder);

// These setter functions are used internally by the framework, so they are not exposed to Gdk developers.
GdkFx(kStatus) GdkRangeInput_Set(GdkRangeInput input, const k16s* rangeData, const k8u* intensityData);
GdkFx(kStatus) GdkProfileInput_Set(GdkProfileInput input, kSize length, const k16s* rangeData, const k8u* intensityData);
GdkFx(kStatus) GdkRawProfileInput_Set(GdkRawProfileInput input, kSize length, const kPoint16s* rangeData, const k8u* intensityData);
GdkFx(kStatus) GdkSurfaceInput_Set(GdkSurfaceInput input, kSize rowCount, kSize colCount, const k16s* rangeData, const k8u* intensityData);
GdkFx(kStatus) GdkRawSurfaceInput_Set(GdkRawSurfaceInput input, kSize rowCount, kSize colCount, const kPoint3d16s* rangeData, const k8u* intensityData);
GdkFx(kStatus) GdkGenericInput_Set(GdkGenericInput input, kSize size, const k8u* data);

#endif
