#ifndef GDK_EXAMPLE_TOOL_DATA_OUTPUT_X_H
#define GDK_EXAMPLE_TOOL_DATA_OUTPUT_X_H

#define GDK_EXAMPLE_TOOL_DATA_OUTPUT_NAME        "ExampleToolDataOutput"

typedef struct GdkExampleToolDataOutputClass 
{
    GdkToolClass base;
    kArray1 array;
    k32u    count;

    kSize measurementIndexZScale;
    kSize measurementIndexPointCount;
    kSize featureIndexLineFeature;
    kSize featureIndexCircleFeature;
    kSize dataoutputIndexProfile1;
    kSize dataoutputIndexSurface1;
    kSize dataoutputIndexProfile2;
    kSize dataoutputIndexSurface2;
    kSize dataoutputIndexGeneric1;
    kSize dataoutputIndexGeneric2;
    kSize dataoutputIndexProfilePointCloud;
} GdkExampleToolDataOutputClass;

kDeclareClassEx(Gdk, GdkExampleToolDataOutput, GdkTool)

GdkFx(const kChar*) GdkExampleToolDataOutput_VName();
GdkFx(kStatus) GdkExampleToolDataOutput_VDescribe(GdkToolInfo info);

GdkFx(kStatus) GdkExampleToolDataOutput_VInit(GdkExampleToolDataOutput info, kType type, kAlloc alloc);
GdkFx(kStatus) GdkExampleToolDataOutput_VRelease(GdkExampleToolDataOutput info);
GdkFx(kStatus) GdkExampleToolDataOutput_VNewToolConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VNewMeasurementConfig(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VCalcDataOutputRegion(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);
GdkFx(kStatus) GdkExampleToolDataOutput_VStart(GdkExampleToolDataOutput tool);
GdkFx(kStatus) GdkExampleToolDataOutput_VStop(GdkExampleToolDataOutput tool);
GdkFx(kStatus) GdkExampleToolDataOutput_VProcess(GdkExampleToolDataOutput tool, GdkToolInput input, GdkToolOutput output);

GdkFx(kStatus) GdkExampleToolDataOutput_VNewToolConfigInstanced(GdkExampleToolDataOutput tool, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VNewMeasurementConfigInstanced(GdkExampleToolDataOutput tool, GdkMeasurementCfg measurementConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VNewFeatureConfigInstanced(GdkExampleToolDataOutput tool, GdkFeatureCfg featureConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VNewToolDataOutputConfigInstanced(GdkExampleToolDataOutput tool, GdkToolDataOutputCfg toolDataOutputConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VUpdateConfigInstanced(GdkExampleToolDataOutput tool, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkExampleToolDataOutput_VCalcDataOutputRegionInstanced(GdkExampleToolDataOutput tool, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);

#endif
