/**
* @file     GdkGraphicLabel.x.h
*
* @internal
* Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_LABEL_X_H
#define GDK_GRAPHIC_LABEL_X_H

#include <kApi/Data/kMath.h>
#include <kApi/Data/kString.h>

#include <Gdk/GdkDef.h>

typedef struct GdkGraphicLabelClass
{
    kObjectClass base;
    kString text;
    kPoint3d64f position;
} GdkGraphicLabelClass;

kDeclareClassEx(Gdk, GdkGraphicLabel,kObject)

#define GdkGraphicLabelTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicLabel))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicLabel_Init(GdkGraphicLabel graphic, kType classType, kAlloc allocator);
GdkFx(kStatus) GdkGraphicLabel_Release(GdkGraphicLabel graphic);

GdkFx(kStatus) GdkGraphicLabel_VRelease(GdkGraphicLabel graphic);
GdkFx(kStatus) GdkGraphicLabel_Serialize(GdkGraphicLabel graphic, kSerializer serializer);

#endif
