#ifndef GDK_EXT_PARAMS_INFO_Z_H
#define GDK_EXT_PARAMS_INFO_Z_H

#include <Gdk/Config/GdkParamsInfo.h>
#include <Gdk/Config/GdkParamInfo.h>
#include <Gdk/Utils/GdkUtils.h>
#include <kApi/Data/kArrayList.h>

typedef struct GdkParamsInfoClass
{
    kObjectClass base;
    kArrayList params;
} GdkParamsInfoClass;

#define GdkParamsInfoTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkParamsInfo))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkParamsInfo_Init(GdkParamsInfo info, kType type, kAlloc alloc);
GdkFx(kStatus) GdkParamsInfo_VRelease(GdkParamsInfo info);

GdkFx(kStatus) GdkParamsInfo_Construct(GdkParamsInfo* info, kAlloc alloc);

GdkFx(kStatus) GdkParamsInfo_Assign(GdkParamsInfo info, GdkParamsInfo source);

// the function below is not fully supported but may in the future. Hide it here for now.
GdkFx(kStatus) GdkParamsInfo_AddString(GdkParamsInfo info, const kChar* name, const kChar* label, const kChar* defVal, GdkParamInfo* paramInfo);

#endif
