/**
* @file    GdkFeatureCfg.h
* @brief   Declares the GdkFeatureCfg class.
*
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_FEATURE_CFG_H
#define GDK_FEATURE_CFG_H

#include <Gdk/GdkDef.h>
#include <Gdk/Config/GdkToolOutputCfg.h>
#include <Gdk/Config/GdkParams.h>

/**
* Represents configuration for a feature.
*
* @class       GdkFeatureCfg
* @ingroup     Gdk-Config
*/
typedef kPointer GdkFeatureCfg;

/**
* Returns the feature Data type.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @return               Pointer to type name.
*/
GdkFx(GdkFeatureDataType) GdkFeatureCfg_DataType(GdkFeatureCfg config);

/**
* Returns the feature Type name.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @return               Pointer to type name.
*/
GdkFx(const kChar*) GdkFeatureCfg_Type(GdkFeatureCfg config);

/**
* Returns the feature ID.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @return               Feature ID.
*/
GdkFx(k32s) GdkFeatureCfg_Id(GdkFeatureCfg config);

/**
* Returns the feature name.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @return               Pointer to name.
*/
GdkFx(const kChar*) GdkFeatureCfg_Name(GdkFeatureCfg config);

/**
* Returns feature enabled state.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @return               Enabled state.
*/
GdkFx(kBool) GdkFeatureCfg_Enabled(GdkFeatureCfg config);

/**
* Returns user-defined parameter set.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @return               Parameter set.
*/
GdkFx(GdkParams) GdkFeatureCfg_Parameters(GdkFeatureCfg config);

/**
* Sets the name of the feature.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @param    name        Name to set to.
* @return               Operation status.
*/
GdkFx(kStatus) GdkFeatureCfg_SetName(GdkFeatureCfg config, const kChar* name);

/**
* Sets the enabled state of the feature.
*
* @public               @memberof GdkFeatureCfg
* @param    config      Configuration object.
* @param    flag        True to enable, false to disable.
* @return               Operation status.
*/
GdkFx(kStatus) GdkFeatureCfg_SetEnabled(GdkFeatureCfg config, kBool flag);

#include <Gdk/Config/GdkFeatureCfg.x.h>

#endif 
